(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10668,        365]*)
(*NotebookOutlinePosition[     11599,        396]*)
(*  CellTagsIndexPosition[     11555,        392]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Classify Points\n",
  StyleBox["as being ordinary, regular singular or irregular singular",
    FontSize->12]
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
Modified slightly 4/12/98 to be compatible with V 3.0  C. C. Ross
Now compatible with V 5.0\
\>", "Text",
  FontSize->10],

Cell[TextData[{
  "In this notebook we define a function, ",
  StyleBox["Classify",
    FontWeight->"Bold"],
  ", which classifies the point x0 as being an ordinary or regular singular \
or irregular singular point of the differential operator L[x, y]. Classify \
uses the function ",
  StyleBox["RSP",
    FontWeight->"Bold"],
  " which is also defined here. RSP says whether or not a singular point is \
regular.\n\nThese functions also appear in the package ",
  StyleBox["SeriesSolveDE.m",
    FontWeight->"Bold"],
  " ."
}], "Text",
  CellMargins->{{Inherited, Inherited}, {5, 5}},
  CellElementSpacings->{"GroupIconBottomMargin"->5},
  Evaluatable->False,
  AspectRatioFixed->False,
  Magnification->1],

Cell[CellGroupData[{

Cell["Definitions of the Active Functions", "Section",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Off[Limit::"\<nlm\>"]\), "\n", 
    \(Off[Pattern::"\<rhs\>"]\), "\n", 
    \(Off[RuleDelayed::"\<rhs\>"]\)}], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(Classify::"\<usage\>" = "\<Classify[x,x0,y,L] classifies the point x0 \
as being an ordinary, regular singular, or irregular singular point of the \
differential operator L[x, y], where x is the independent variable and y \
dependent. L may be presented by name or by value.\>";\)\)], "Input",
  PageWidth->PaperWidth,
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["RSP",
    FontWeight->"Bold"],
  " is a helper for ",
  StyleBox["Classify",
    FontWeight->"Bold"],
  ".\n",
  StyleBox["RSP",
    FontWeight->"Bold"],
  " returns ",
  StyleBox["True",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " of x0 is regular; otherwise ",
  StyleBox["False",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". "
}], "Text",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(\(Clear[RSP];\)\), "\n", 
    \(RSP[x_, x0_, CList_] := 
      Module[{CLLen, CListQuotients, LimitList}, CLLen = Length[CList] - 1; 
        CListQuotients = \(CList\ Table[\((x - x0)\)\^\(CLLen - i\), {i, 0, \
CLLen}]\)\/Last[CList]; 
        LimitList = \((Limit[#1, x \[Rule] x0] &)\) /@ CListQuotients; 
        And @@ \(NumberQ /@ LimitList\)]\)}], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  InitializationCell->True,
  AspectRatioFixed->False],

Cell["\<\
Note that the operator L can be supplied by name or as an \
expression.\
\>", "Text",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->False],

Cell["\<\
Clear[Classify]; 
Classify[x_, x0_, y_, L_] := 
  Module[{CList, p, r, LocalL}, 
   LocalL[x_, y_] = If[TrueQ[AtomQ[L]], L[x, y], L]; 
    CList = 
     CoefficientList[LocalL[x, y] /. 
       {Derivative[p_][y][x] -> r^p, y[x] -> 1}, r]; 
    Which[TrueQ[Limit[Last[CList], x -> x0] != 0], 
     Print[StringForm[\"The point x0 = `` is an ordinary point.\", x0]], \
RSP[x, x0, CList], 
     Print[StringForm[\"The point x0 = `` is a regular singular point.\", \
x0]], True, 
     Print[StringForm[\"The point x0 = `` is an irregular singular point.\", \
x0]]]; ]\
\>", "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(On[Pattern::"\<rhs\>"]\), "\n", 
    \(On[RuleDelayed::"\<rhs\>"]\)}], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Classify", "Subsection",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(\((x\^2 - 1)\)\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"5", " ", \((x - 1)\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((x\^4 - 1)\)\ y[x]\)}]}]], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\((\(-1\) + x\^4)\)\ y[x]\), "+", 
      RowBox[{"5", " ", \((\(-1\) + x)\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(\((\(-1\) + x\^2)\)\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[x, 0, y, L[x, y]]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox["\<\"The point x0 = \\!\\(0\\) is an ordinary \
point.\"\>",
      StringForm[ "The point x0 = `` is an ordinary point.", 0],
      Editable->False]], "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Classify", "[", 
      RowBox[{"x", ",", "0", ",", "y", ",", 
        RowBox[{
          RowBox[{\(\((x\^2 - 1)\)\^2\), " ", 
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"5", " ", \((x - 1)\), " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], 
          "+", \(\((x\^4 - 1)\)\ y[x]\)}]}], "]"}]], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox["\<\"The point x0 = \\!\\(0\\) is an ordinary \
point.\"\>",
      StringForm[ "The point x0 = `` is an ordinary point.", 0],
      Editable->False]], "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[x, 1, y, L[x, y]]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox["\<\"The point x0 = \\!\\(1\\) is a regular singular \
point.\"\>",
      StringForm[ "The point x0 = `` is a regular singular point.", 1],
      Editable->False]], "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[x, \(-1\), y, L[x, y]]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox["\<\"The point x0 = \\!\\(-1\\) is an irregular \
singular point.\"\>",
      StringForm[ "The point x0 = `` is an irregular singular point.", -1],
      Editable->False]], "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[x, \(-1\), y, L]\)], "Input",
  CellMargins->{{Inherited, Inherited}, {Inherited, 12}},
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox["\<\"The point x0 = \\!\\(-1\\) is an irregular \
singular point.\"\>",
      StringForm[ "The point x0 = `` is an irregular singular point.", -1],
      Editable->False]], "Print"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["RSP can be used alone"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSP[x, 1, {x\^4 - 1, 5\ \((x - 1)\), x\^2 - 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSP[x, \(-1\), {x\^4 - 1, 5\ \((x - 1)\), x\^2 - 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSP[x, 1, {x\^4 - 1, 5\ \((x - 1)\), \((x\^2 - 1)\)\^2}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RSP[
      x, \(-1\), {x\^4 - 1, 5\ \((x - 1)\), \((x\^2 - 1)\)\^2}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{546, 440},
WindowMargins->{{52, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 193, 6, 81, "Subtitle",
  Evaluatable->False],
Cell[1972, 61, 131, 4, 44, "Text"],
Cell[2106, 67, 708, 19, 100, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2839, 90, 189, 4, 44, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[3031, 96, 253, 6, 64, "Input",
  InitializationCell->True],
Cell[3287, 104, 452, 8, 128, "Input",
  InitializationCell->True],
Cell[3742, 114, 528, 22, 55, "Text",
  Evaluatable->False,
  InitializationCell->True],
Cell[4273, 138, 497, 10, 175, "Input",
  InitializationCell->True],
Cell[4773, 150, 230, 7, 37, "Text",
  Evaluatable->False,
  InitializationCell->True],
Cell[5006, 159, 701, 18, 227, "Input",
  InitializationCell->True],
Cell[5710, 179, 213, 5, 48, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5960, 189, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[6049, 193, 71, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[6145, 199, 137, 3, 38, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6307, 206, 546, 13, 37, "Input"],
Cell[6856, 221, 417, 9, 30, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7310, 235, 144, 3, 32, "Input"],
Cell[7457, 240, 195, 4, 23, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[7689, 249, 615, 14, 37, "Input"],
Cell[8307, 265, 195, 4, 23, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[8539, 274, 144, 3, 32, "Input"],
Cell[8686, 279, 209, 4, 23, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[8932, 288, 149, 3, 32, "Input"],
Cell[9084, 293, 217, 4, 23, "Print"]
}, Closed]],

Cell[CellGroupData[{
Cell[9338, 302, 143, 3, 32, "Input"],
Cell[9484, 307, 217, 4, 23, "Print"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9750, 317, 102, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9877, 323, 107, 2, 31, "Input"],
Cell[9987, 327, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10062, 333, 112, 2, 31, "Input"],
Cell[10177, 337, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10252, 343, 116, 2, 32, "Input"],
Cell[10371, 347, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10446, 353, 128, 3, 32, "Input"],
Cell[10577, 358, 39, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

Cell[10727, 358, 124, 3, 32, "Input"],
Cell[10854, 363, 39, 1, 26, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

